##load necessary software
module load java 
module load trimmomatic 
module load bowtie2 
module load samtools
module load picard
module load macs2
module load bedtools
module load homer
##Reading sample ID
ID=$( sed -n ${SLURM_ARRAY_TASK_ID}p ~/lookup_PFC.txt ) 
#Raw reads trimming
java -jar $TRIMMOMATIC_HOME/trimmomatic-0.38.jar PE -phred33 -threads 12 \
     ~/raw/${ID}_L002_R1.fastq.gz ~/raw/${ID}_L002_R2.fastq.gz \
     -baseout ~/results/trimmed/${ID}_trimmed.fastq.gz \
     ILLUMINACLIP:~/trimmomatic/0.38/adapters/TruSeq3-PE.fa:2:30:10 LEADING:20 TRAILING:20 MINLEN:25
     
##Reads alignment
bowtie2 -x ~/mouse_bowtie2_index/mouse_bowtie2_index \
        --local --very-sensitive-local --no-unal --no-mixed --no-discordan --phred33 \
        -I 10 -X 700 -p2 -1 ~/results/trimmed/${ID}_trimmed_1P.fastq.gz \
        -2 ~/results/trimmed/${ID}_trimmed_2P.fastq.gz \
        -S ~/results/post_bowtie2_align/${ID}.sam &> ~/results/post_bowtie2_align/${ID}.bowtie2.txt
        
##Reads filtering
samtools view -bS -F 0x04 ~/post_bowtie2_align/${ID}.sam > ~/rmDups/${ID}.mapped.bam
samtools sort -o ~/rmDups/${ID}.sorted.bam ~/rmDups/${ID}.mapped.bam
samtools view -h ~/rmDups/${ID}.sorted.bam | grep -v MT | samtools view -b -o ${dir}/rmDups/${ID}.rmChrM.bam
samtools view -h -b -q 30 ~/rmDups/${ID}.rmChrM.bam > ~/rmDups/${ID}.rmChrM.q30.bam 

##Remove PCR duplicates
java -jar ~/picard-tools/2.18.2/picard.jar MarkDuplicates \
I=~/rmDups/${ID}.m.rmChrM.q30.bam \
O=~/rmDups/${ID}.nodup.bam \
TMP_DIR=/tmp/picard-${SLURM_JOB_ID} \
M=~/rmDups/${ID}_dups.txt \
REMOVE_DUPLICATES=true
rm ~/rmDups/${ID}.mapped.bam
rm ~/rmDups/${ID}.sorted.bam
rm ~/rmDups/${ID}.rmChrM.bam
rm ~/after_filter/${ID}.rmChrM.q30.bam

##Peak calling
mkdir ~/macs2/${ID}/q.05
macs2 callpeak -f BAMPE -g mm --keep-dup all --cutoff-analysis -n ${ID}.q.05 -q 0.05 \
  -t ~/rmDups/${ID}.m.bam \
  -c ~/rmDups/wt_igg.downsampled.bam \
  --outdir ~/macs2/${ID}/q.05 2> ~/macs2/${ID}/q.05/${ID}.q.05.macs2.log

##Finding consensus peaks
bedtools intersect -u -a ~/macs2/2_wt/q.05/2_wt.q.05_peaks.narrowPeak \
                   -b ~/macs2/3_wt/q.05/3_wt.q.05_peaks.narrowPeak > ~/macs2/pfc_overlapped_peak_intrim.narrowPeak

bedtools intersect -u -a ~/macs2/pfc_overlapped_peak_intrim.narrowPeak \
                   -b ~/macs2/4_wt/q.05/4_wt.q.05_peaks.narrowPeak > ~/macs2/pfc_overlapped_peak.narrowPeak

rm ~/macs2/pfc_overlapped_peak_intrim.narrowPeak

##Homer motif analysis
findMotifsGenome.pl ~/macs2/cr_pfc_overlapped_peaks.bed \
                    mm10 ~/homer/pfc_given -size given \
                    -bg /scratch/jdlab/jiayang/new_calling/all_pfc_atac_peaks.bed 

##Getting peak coverage for histone CUT&RUN
bedtools coverage -a ~/macs2/wt_h3k27ac/q.05/wt_h3k27ac.q.05_peaks.narrowPeak \
-b ~/rmDups/${ID}_h3k27ac.nodup.bam > ~/read_counts/${ID}_h3k27ac.read.counts.bed
